//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.20 Page 433
//Title: Net Radiant Heat Exchange
//======================================================

model Ex10_20
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1073 " Temperature of first plate";
parameter Real T2(unit="K")=573 " Temperature of second plate";
parameter Real e1(unit="")=0.3 " Emissivity of first plate";
parameter Real e2(unit="")=0.5 " Emissivity of second plate";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW/m^2")" Heat exchange per unit area";

//=============
// Equation Section

equation

Q=sigma*((T1^4)-(T2^4))/(((1/e1)+(1/e2)-1)*1000);

end Ex10_20;
//======================================================
