//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.21 Page 434
//Title: Loss of heat per unit area
//======================================================

model Ex10_21
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=400 " Temperature of outer brick";
parameter Real T2(unit="K")=323 " Temperature of inside of steel plate";
parameter Real e1(unit="")=0.6 " Emissivity of steel";
parameter Real e2(unit="")=0.8 " Emissivity of fireclay brick";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="W/m^2")" Heat exchange per unit area";

//=============
// Equation Section

equation

Q=sigma*((T1^4)-(T2^4))/((1/e1)+(1/e2)-1);

end Ex10_21;
//======================================================
