//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.23 Page 447
//Title: Percentage reduction in heat transfer
//======================================================

model Ex10_23
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1073 " Temperature of first plate";
parameter Real T2(unit="K")=573 " Temperature of second plate";
parameter Real e1(unit="")=0.3 " Emissivity of first plate";
parameter Real e2(unit="")=0.5 " Emissivity of second plate";
parameter Real e3(unit="")=0.05 " Emissivity of aluminium";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW/m^2")" Heat exchange per unit area";
Real R1(unit="") " Resistance 1";
Real R2(unit="") " Resistance 2";
Real R3(unit="") " Resistance 3";
Real Rt(unit="") " Total Resistance";
Real Qn(unit="kW/m^2")" Changed Heat exchange per unit area";
Real Red(unit="")" Percentage Reduction in heat loss";
Real X1(unit="") " To find T3";
Real X2(unit="") " To find T3";
Real T3(unit="K") " Temperature";

//=============
// Equation Section

equation

Q=sigma*((T1^4)-(T2^4))/(((1/e1)+(1/e2)-1)*1000);
R1=(1-e1)/e1;
R2=(1-e2)/e2;
R3=(1-e3)/e3;
Rt=R1+(2*R2)+(2*R3)+1;
Qn=sigma*((T1^4)-(T2^4))/(Rt*1000);
Red=(Q-Qn)*100/Q;
X1=(1/e3)+(1/e2)-1;
X2=(1/e3)+(1/e1)-1;
T3=((( X1*T1^4 )+ (X2*T2^4))/(X1+X2))^0.25;

end Ex10_23;
//======================================================
