//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.25 Page 449
//Title: Heat loss and heat reduction
//======================================================

model Ex10_25
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=773 " Temperature of surface";
parameter Real T2(unit="K")=303 " Temperature of enclosure";
parameter Real T3(unit="K")=513 " Temperature of screen";
parameter Real e1(unit="")=0.8 " Emissivity";
parameter Real e2(unit="")=0.7 " Emissivity of steel";
parameter Real d1(unit="m")=27.5e-2 " Diameter";
parameter Real d2(unit="m")=32.5e-2 " Diameter of screen";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW/m")" Heat exchange";
Real Qn(unit="kW/m")" Change in heat exchange";
Real Qchange(unit="kW/m")" Change in heat loss";
Real ee(unit="") " Equivalent emissivity";

//=============
// Equation Section

equation

Q=sigma*e1*pi*d1*((T1^4)-(T2^4))/1000;
Qn=sigma*ee*pi*d1*((T1^4)-(T3^4))/1000;
Qchange=Q-Qn;
(1/ee)=(1/e1)+ (d1/d2)*((1/e2)-1);

end Ex10_25;
//======================================================
