//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.26 Page 451
//Title: Error in temperature
//======================================================

model Ex10_26
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=773 " Temperature of thermocouple";
parameter Real T2(unit="K")=293 " Ambient temperature";
parameter Real ec(unit="")=0.6 " Emissivity of thermocouple";
parameter Real es(unit="")=0.3 " Emissivity of shield";
parameter Real h(unit="W/m^2 K")=200 " Heat transfer coefficient";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tx(unit="K") " Temperature actual";
Real Te(unit="K") " Temperature error";
Real Ts(unit="K") " Temperature of surface with shield";
Real Tc(unit="K") " Temperature of thermocouple with shield";

//=============
// Equation Section

equation

h*(Tx-T1)=sigma*ec*((T1^4)-(T2^4));
Te=Tx-T1;
2*h*(Tx-Ts)=sigma*es*((T2^4)-(Ts^4));
h*(Tx-Tc)=sigma*ec*((Ts^4)-(Tc^4));

//Error in value of Ts. This is because h is taken as 0.2 instead of 200. Ts is thus 854K and Tc is 817K

end Ex10_26;
//======================================================
