//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.27 Page 452
//Title: Rate of heat loss
//======================================================

model Ex10_27
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=473 " Temperature of thermocouple";
parameter Real T2(unit="K")=303 " Ambient temperature";
parameter Real e(unit="")=0.8 " Emissivity of pipe";
parameter Real d(unit="m") =0.2 " Diameter";

//Properties of air at 115C
parameter Real B(unit="K^-1") =2.577e-3 "  Volumetric Coefficient";
parameter Real v1(unit="m^2/s") =24.93e-6 " Kinematic viscosity";
parameter Real k(unit="W/mK") =33.06e-3 " Thermal Conductivity";
parameter Real Pr(unit="") =0.687 " Prandtl No";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Qr(unit="W/m") " Heat lost by thermal radiation";
Real Qc(unit="W/m") " Heat lost by convection";
Real Qt(unit="kW/m") " Heat lost in total";
Real Gr(unit="") " Grashoff No";
Real Nu(unit="") " Nusselt No";
Real h(unit="W/m^2 K") " Heat transfer coefficient";

//=============
// Equation Section

equation

Qr=e*pi*d*sigma*((T1^4)-(T2^4));
Gr=(g_n*B*(T1-T2)*(d^3))/(v1*v1);
Nu=0.53*(Gr*Pr)^0.25;
Nu=h*d/k;
Qc=h*pi*d*(T1-T2);
Qt=(Qc+Qr)/1000;

end Ex10_27;
//======================================================
