//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.29 Page 461
//Title: Extinction Coefficient
//======================================================

model Ex10_29
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=50e-3 " Thickness of gas layer";
parameter Real r(unit="")=0.1 " Intensity of radiation remaining";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real a(unit="1/m")" Extinction coefficient";

//=============
// Equation Section

equation

a=(-1/x)*log(r);

end Ex10_29;
//======================================================
