//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.4 Page 409
//Title: Net exchange of energy
//======================================================

model Ex10_4
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=1173 " Temperature of first plate";
parameter Real T2(unit="K")=673 " Temperature of second plate";
parameter Real D(unit="m")=0.4 " Distance";
parameter Real L(unit="m")=1 " Length of side of square";
parameter Real F(unit="")=0.415 " Shape factor"; //Obtained from Fig10.4 on pg409

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW")" Heat transferred";

//=============
// Equation Section

equation

Q=sigma*L*L*F*((T1^4)-(T2^4))/1000;

end Ex10_4;
//======================================================
