//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.8 Page 415
//Title: Net Heat Exchange
//======================================================

model Ex10_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=313 " Temperature of floor";
parameter Real T2(unit="K")=278 " Temperature of window";
parameter Real Tw(unit="K")=304 " Temperature of other walls and ceiling";
parameter Real A(unit="m^2")=120 " Area";
parameter Real F56(unit="")=0.075 " Shape factor";
parameter Real F63(unit="")=0.04 " Shape factor";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real F12(unit="")" Shape factor";
Real F1w(unit="")" Shape factor";
Real Q12(unit="W")" Heat transferred between floor and window";
Real Q1(unit="kW")" Net Heat given by floor";

//=============
// Equation Section

equation

F12=(1/A)*((8*12*F56)-(2*12*F63));
F1w=1-F12;
Q12=sigma*A*F12*((T1^4)-(T2^4));
Q1=(sigma*A)*((T1^4)-( (F12*T2^4)-(F1w*Tw^4) ))/1000;

//Error in value of Q1. This is because Tw is taken as 293K instead of 303K(31C) as mentioned in the question.

end Ex10_8;
//======================================================
