//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.4 Page 485
//Title: Change in Heat transfer Coefficient
//======================================================

model Ex11_4

extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Pa(unit = " atm ") = 1 " Atmospheric pressure "; 
parameter Real P[3](unit = " atm ") = {10,10,20} " Boiling pressure "; 
parameter Real T[3](unit = "C") ={10,20,10} " Temperature difference ";

//=============
// Variable Section

Real hp[3](unit= "kW/m^2 K") " Heat transfer coefficient at given pressure";
Real ha[3](unit= "kW/m^2 K") " Heat transfer coefficient at atmospheric pressure ";

//=============
// Equation Section

equation

for i in 1:3 loop
ha[i] =5.56*(T[i]^3)*1e-3;// From Table 11.2 on Pg 484 assuming qs > 15.8kW/M^2
hp[i] =ha[i]*(P[i]/Pa)^0.4; 
end for;
//Indices 1,2,3 indicate initial, change in part(a),change in part(b) respectively

end Ex11_4;
//======================================================
