//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.8 Page 492
//Title: Heat transfer per unit width
//======================================================

model Ex11_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = " C ") = 54 " Surface temperature ";
parameter Real H(unit = " m ") = 2.8 " Height of plate "; 

//Properties of Saturated Vapour at 100 degree celsius
parameter Real Tsat(unit = "C") =100 " Temperature saturated ";
parameter Real pv(unit = "kg/m^3" )=0.596 " Density of steam ";
parameter Real hfg(unit = "kJ/kg" )=2257 " Enthalpy of steam ";

//Saturated Water at Film Temperature of 77 degree celsius
parameter Real pl(unit = "kg/m^3" )=973.7 " Density of water ";
parameter Real ul(unit = "Pa s" )=365e-6 " Viscosity of water ";
parameter Real kl(unit = "W/m K" )=668e-3 " Thermal Conductivity of water ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real hl(unit= "W/m^2 K") " Local Heat transfer coefficient ";
Real Re(unit= "") " Film Reynolds number ";
Real Q(unit ="kW/m") "Heat transfer rate ";

//=============
// Equation Section

equation

Re=(0.00296*((pl*g_n*(pl-pv)*kl^3*(Tsat-T)^3*H^3)/(ul^5*(hfg*1000)^3))^(5/9));
hl=0.0077*( (g_n*pl*(pl-pv)*kl^3) / (ul^2) )^(1/3) * Re^0.4;
Q=hl*H*(Tsat-T)/1000;

end Ex11_8;
//======================================================
