//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.1 Page 503
//Title: Overall Heat Transfer Coefficient
//======================================================

model Ex12_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit = " C ") = 80 " Water temperature "; 
parameter Real D[2](unit = " m ") = {2.54e-2,2.88e-2} " Inner and Outer diameters of tube respectively ";
parameter Real k(unit = "W/m C") = 50 " Thermal Conductivity of steel ";
parameter Real ho(unit= "W/m^2 C")=30800 " Average convection coefficient";
parameter Real v(unit= "m/s")=50e-2 " Water velocity";

//Properties of water at 80 
parameter Real k1(unit = "W/m C") = 668.7e-3 " Thermal Conductivity of water ";
parameter Real d(unit= "kg/m^3")=974 " Density of water";
parameter Real v1(unit= "m^2/s")=0.364e-6 " Kinematic viscosity";
parameter Real Pr(unit= "")=2.2 " Prandtl Number";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "") " Reynolds Number ";
Real Nu(unit= "") " Nusselt Number ";
Real hi(unit= "W/m^2 C")" Heat transfer coefficient inside";
Real Uo(unit= "W/m^2 C")" Overall Heat transfer coefficient";

//=============
// Equation Section

equation

Re=D[1]*v/v1;
Nu=0.023*(Re^0.8)*(Pr^0.4);
hi=Nu*k1/D[1];
(1/Uo)=(1/ho)+((D[2]/2)*log(D[2]/D[1])/k) + (D[2]/(hi*D[1]));

end Ex12_1;
//======================================================
