//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.14 Page 528
//Title: Parameters of heat exchangers
//======================================================

model Ex12_14
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Ts(unit = " C ") = 50 " Steam condensation temperature";
parameter Real Tci(unit = " C ") = 20 " Cold Water inlet temperature";
parameter Real mc(unit = " kg/s ") = 3000 " Cold Water flow rate";
parameter Real NTU(unit= "")=0.8 " Number of transfer units ";//Obtained from the figure 12.16 on pg 525
parameter Real ho(unit = " W/ m^2 K ") =15500 " Outside heat transfer coefficient";
parameter Real d(unit ="m")=20e-3 " Diameter of pipe ";
parameter Real N(unit="") =3000 "No of pipes";
parameter Real Q(unit= "W")=2.3e8" Heat duty ";
parameter Real hfg(unit = " kJ/kg ") = 2380e3 " Latent heat of steam";

//Property valules of water at 300K
parameter Real Cpc(unit = " J/kg K ") = 4180 " Cold Water specific heat capacity";
parameter Real k(unit= "W")=0.613" Thermal conductivty ";
parameter Real v1(unit= "W")=855e-6" Kinematic viscosity ";
parameter Real Pr(unit ="") =5.83 "Prandtl number ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tco(unit = " C ") " Cold Water outlet temperature";
Real Cmin(unit = " W/K ") " Minimum heat capacity";
Real Re(unit= "")" Reynolds number ";
Real Nu(unit= "")" Nusselt number ";
Real hi(unit = " W/ m^2 K ") " Inside heat transfer coefficient";
Real U(unit = " W/ m^2 K ") " Overall heat transfer coefficient";
Real Qmax(unit= "W")" Maximum Heat transfer rate ";
Real A(unit="m^2") " Area of heat exchanger ";
Real L(unit="m") " Tube length per pass ";
Real ms(unit = " kg/s ") " Steam condensation rate";
Real E(unit="") "Effectiveness of heat exchanger";

//=============
// Equation Section

equation

Q=mc*Cpc*(Tco-Tci);
Re=4*1/(pi*d*v1);
Nu=0.023*Re^0.8*Pr^0.4;
hi=Nu*k/d;
(1/U)=(1/hi)+(1/ho);
Cmin=mc*Cpc;
Qmax=Cmin*(Ts-Tci);
E=Q/Qmax;
NTU=U*A/Cmin;
A=N*2*L*pi*d;
Q=ms*hfg;

end Ex12_14;
//======================================================
