//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.3 Page 509
//Title: Area of heat exchanger in counter flow
//======================================================

model Ex12_3
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Th[2](unit = " C ") = {80,50} " Oil inlet and outlet temperatures respectively ";
parameter Real mh(unit = " kg/hour ") = 10000 " Oil flow rate";
parameter Real mc(unit = " kg/hour ") = 8000 " Water flow rate";
parameter Real Cph(unit = " J/ kg K ") = 2095 " Oil specific heat capacity";
parameter Real Cpc(unit = " J/ kg K ") = 4180 " Water specific heat capacity";
parameter Real U(unit = " W/ m^2 K ") = 300 " Overall heat transfer coefficient";
parameter Real Tci(unit = " C ") = 25 " Water inlet temperature ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real A(unit= "m^2 ")" Area of heat exchanger";
Real Tco(unit = " C ") " Water outlet temperature ";
Real Tlmtd(unit = " C ") "Log Mean temperature difference ";

//=============
// Equation Section

equation

mh*Cph*(Th[1]-Th[2])=mc*Cpc*(Tco-Tci);
Tlmtd=((Th[1]-Tco)-(Th[2]-Tci))/(log((Th[1]-Tco)/(Th[2]-Tci)));
A=(mh*Cph*(Th[1]-Th[2])/3600)/(Tlmtd*U);


end Ex12_3;
//======================================================
