//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-12: Heat Exchangers
//Example: 12.4 Page 510
//Title: Area of heat exchanger in parallel and counter flow
//======================================================

model Ex12_4
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Th[2](unit = " C ") = {360,300} " Oil inlet and outlet temperatures respectively ";
parameter Real Ch(unit = " W/ K ") = 2500 " Oil heat capacity";
parameter Real U(unit = " W/ m^2 K ") = 800 " Overall heat transfer coefficient";
parameter Real Tc[2](unit = " C ") = {30,200} " Water inlet and outlet temperatures respectively ";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit= "W")" Heat transfer rate ";
Real A[2](unit= "m^2 ")" Area of heat exchanger in parallel and counter flow respectively";
Real Tlmtd[2](unit = " C ") "Log Mean temperature difference in parallel and counter flow respectively";

//=============
// Equation Section

equation

Ch*(Th[1]-Th[2])=Q;

Tlmtd[1]=((Th[1]-Tc[1])-(Th[2]-Tc[2]))/(log((Th[1]-Tc[1])/(Th[2]-Tc[2])));
A[1]=Q/(Tlmtd[1]*U);

Tlmtd[2]=((Th[1]-Tc[2])-(Th[2]-Tc[1]))/(log((Th[1]-Tc[2])/(Th[2]-Tc[1])));
A[2]=Q/(Tlmtd[2]*U);

end Ex12_4;
//======================================================
