//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.7 Page 563
//Title: Diffusion rate
//======================================================

model Ex13_7
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit = "m") = 4e-2 " Length ";
parameter Real D(unit = "m") = 20e-3 " Diameter ";
parameter Real T(unit = "C") = 27 " Temperature";
parameter Real P(unit = "bar") = 1.01325 " Pressure ";
parameter Real Pa[2](unit = "bar") = {0.03531,0} " Partial pressure at both ends";
parameter Real DAB(unit= "m^2/s")=0.26e-4 " Diffusion coefficient ";//Obtained from table 13.3 on pg 549

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nax(unit = " kmol/ m^2 s ") " Diffusion ";
Real A(unit=" m^2") "Area ";
Real M(unit =" kg/s ") "Mass flow rate of water ";

//=============
// Equation Section

equation

Nax=DAB*P*1e5*log((P-Pa[2])/(P-Pa[1]))/((T+273)*8316*L);
A=(pi/4)*D^2;
M=18*(Nax)*A;

//Error in answer as 4cm is taken as 0.4m. Answer is 5.28e-9kg/s


end Ex13_7;
//======================================================
