//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-13: Diffusion Mass Transfer
//Example: 13.8 Page 564
//Title: Diffusion coefficient of water
//======================================================

model Ex13_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit = "m") = 8e-2 " Length ";
parameter Real D(unit = "m") = 20e-2 " Diameter ";
parameter Real T(unit = "C") = 25 " Temperature";
parameter Real P(unit = "bar") = 1.01325 " Pressure ";
parameter Real Pa[2](unit = "bar") = {0.03165,0} " Partial pressure at both ends";
parameter Real ma(unit= "kg/hour")=8.54e-4 " Rate of evaporation of water";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real DAB(unit= "m^2/s")" Diffusion coefficient ";
Real A(unit=" m^2") "Area ";

//=============
// Equation Section

equation

A=(pi/4)*D^2;
ma/3600=(18*A*DAB*P*1e5*log((P-Pa[2])/(P-Pa[1])))/((T+273)*8316*L);

end Ex13_8;
//======================================================
