//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.12 Page 67
//Title: Heat Loss and thickness of insulation
//======================================================
package Ex3_12

//=======================================================
model Ex3_12_a

//=============
// Parameter Section

parameter Real  T[2](unit = " C ") = {1100,50}  " Inside and Outside Wall Temperature ";
parameter Real  k[2](unit = " W/m C ") = {0.533,0.7} " Thermal COnductivity of fireclay and red brick ";
parameter Real  t[2](unit = " m ") = {12.5e-2,50e-2} " Thickness of the wall";

//=============
// Variable Section

Real q(unit= "W/m^2") " Heat loss ";
Real R[2](unit= "m^2 C/W ") " Thermal Resistance of wall per unit area";
Real T2(unit = " C ") " Interface Temperature";

//=============
// Equation Section


algorithm
 
for i in 1:2 loop
R[i]:= (t[i]/k[i]);
end for;

equation

q=(T[1]-T[2])/(R[1]+R[2]);
T2=T[1]-(q*R[1]);

end Ex3_12_a;
//======================================================

//=======================================================
model Ex3_12_b

//=======================================================
extends Ex3_12_a ;

//=======================================================
//Variable Section

Real T3(unit = " C ") " New Interface Temperature ";
Real km(unit = " W/m C ")" Thermal Conductivity of diatomite layer ";
Real x(unit = " m ")" Thickness of diatomite layer ";

//=======================================================
//Equation Section

equation

T3=T[2]+q*(R[2]/2);
km=0.113+0.00023*((T2+T3)/2);
x=km*(T2-T3)/q;

end Ex3_12_b ;
//=======================================================

end Ex3_12;
