//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.18 Page 77
//Title: Critical radius and heat transfer rate
//======================================================

model Ex3_18
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {200,20}   " Steam and Ambient Temperatures ";
parameter Real k (unit = " W/ m K ") = 1 "  Thermal Conductivity of pipe ";
parameter Real h (unit = " W/ m^2 K ") = 8 " Heat Transfer coefficient between air & insulation ";
parameter Real r[2] (unit = " m ") = {0.05,0.055} " Respective radii from centre ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;


//=============
// Variable Section

Real Q(unit= " W/m ") " Heat Transfer Rate per unit length ";
Real rc(unit = " m ") " Critical Radius ";
Real To(unit = " C ") "Outer Surface temperature ";

//=============
// Equation Section

equation

rc=k/h;
Q=((T[1]-T[2]))/( (log(rc/r[2])/(2*pi*k)) + (1/(2*pi*rc*h)) );
To= T[2] +(Q/(2*pi*rc*h));

end Ex3_18;
//======================================================
