//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.23 Page 89
//Title: Diameter of Nichrome Heater and Rate of Current
//======================================================

model Ex3_23
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {1220,20}   " Surface and Ambient Air Temperatures ";
parameter Real k (unit = " W/ m K ") = 17 "  Thermal Conductivity of nichrome ";
parameter Real h (unit = " W/ m^2 K ") = 1150 " Outside Heat Transfer coefficient ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
parameter Real L (unit = " m ") = 1 " Length of the wire ";
parameter Real rho (unit= "micro ohm cm") = 100 "Electrical Resistivity ";
parameter Real Q(unit= " W/m ")=10000 " Heat generated ";

//=============
// Variable Section

Real I(unit= " A ") " Current rate ";
Real d (unit = " mm ") " Diameter of wire ";
Real R (unit = " ohm " ) " Resistance "; 
//=============
// Equation Section

equation

d=(Q/((T[1]-T[2])*pi*h))*1000;
R= (rho*10^(-8)*L)/((pi/4)*((d/1000)^2));
I=(Q/R)^0.5;

end Ex3_23;
//======================================================
