//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.28 Page 103
//Title: Fin with an insulated end
//======================================================

model Ex3_28
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = "m") = 0.06  "Length of the blade ";
parameter Real A (unit = "m^2 ") =4.65*10^(-4) "Cross sectional area of the blade "; 
parameter Real P (unit = "m ") = 0.12  "Perimeter of the blade ";
parameter Real T[2] (unit = " C ") ={500,870} "Temperature at root of blade and gas respectively  ";
parameter Real h(unit = "W/m^2 K ") = 442  "Heat transfer coefficient ";
parameter Real k(unit = "W/m K ") = 23.3  "Thermal Conductivity of the blade ";
parameter Real x=0;parameter Real i=1;

//=============
// Variable Section
Real Q(unit= "W") " Heat Transfer Rate ";
Real m(unit= "")  " Value of m ";     

//=============
// Equation Section

equation

m=((h*P)/(k*A))^0.5;
Q=((h*P*k*A)^(0.5))*(T[1]-T[2])*tanh(m*L);

end Ex3_28;
//======================================================
