//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.3 Page 51
//Title: Temperature and Heat Flow of Sphere
//======================================================

model Ex3_3

//=============
// Parameter Section

parameter Real ri(unit = "m") = 0.05 " Inner radius of the sphere";
parameter Real ro(unit = "m") = 0.15 " Outer radius of the cylilnder";
parameter Real Ti(unit = "C") = 300 " Temperature of Inner surface";
parameter Real To(unit = "C") = 100 " Temperature of Outer surface";
parameter Real k(unit = "W/m C") = 50 " Thermal Conductivity of the sphere";
parameter Real r(unit = "m") = 0.075 "Point at quarter of the surface";

//=============
// Variable Section

Real Tx(unit = "C")  " Temperature of quarterway point";
Real Q(unit= "kW") " Heat Transfer Rate";

//=============
// Equation Section

equation

Q= 4*3.14*ro*ri*k*(Ti-To)/(1000*(ro-ri));

Tx= Ti+((To-Ti)*(r-ri)*(ro))/(r*(ro-ri));


end Ex3_3;
//======================================================
