//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.31 Page 109
//Title: Rate of heat flow
//======================================================

model Ex3_31
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = " C ") = {600,40}   " Surface and Ambient Temperature ";
parameter Real L(unit = " m") = 0.1 " Height of fin ";
parameter Real t(unit = " m") =  2.5e-2 " Thickness of fin ";
parameter Real k(unit = "W/ m K") = 17.7 " Thermal Conductivity of the rod ";
parameter Real h(unit = "W/m^2 K") = 20 " Heat transfer coefficient ";
parameter Real p1(unit = "kg/m^3") = 7850 " Density ";
parameter Real Io(unit="")=2.1782 " Modified Bessel function";//Obtained from table 3.2 on Pg108
parameter Real I1(unit="")=1.48871 " Modified Bessel function";//Obtained from table 3.2 on Pg108

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159275358979;

//=============
// Variable Section

Real B(unit= "m^(-1/2)") " Value of B";
Real Q(unit= "W/m") " Heat flow per unit length ";
Real m(unit = "kg/m") " Mass of fin per unit width";
Real Qm(unit = "W/kg") " Heat flow per unit mass";

//=============
// Equation Section
equation

B=((2*L*h)/(k*t))^0.5;
Q=(T[1]-T[2])*(I1/Io)*((2*h*k*t)^0.5);
m=(p1*t*L)/2;
Qm=Q/m;

end Ex3_31;
//======================================================
