//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.33 Page 117
//Title: Heat loss per fin
//======================================================

model Ex3_33
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = "C") = {170,25}  "Base film and ambient temperature of the fluid respectively ";
parameter Real L (unit = "m") = 0.015  "Length of the fin ";
parameter Real t (unit = "m") = 0.001  "Thickness of the fin ";
parameter Real h(unit = "W/m^2 K ")= 130 "Heat transfer coefficient ";
parameter Real k(unit = "W/m K ") = 200 "Thermal Conductivity of aluminium  ";
parameter Real r(unit = "m") =0.0125 "Radius of the tube ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real rc(unit = "m") "Radius correction of the fin ";
Real x(unit= "") " x to find fin efficiency ";
Real Lc(unit = "m") "Length correction of the fin ";
Real Am(unit=" m^2") " Corrected area ";
Real Qmax(unit= "W") " Maximum Heat transfer ";
Real Qactual(unit= "W") " Actual Heat transfer ";
     
//=============
// Equation Section

equation

Lc=L+(t/2);
rc=r+Lc;
Am=t*(rc-r);
x=(Lc^(1.5))*(h/(k*Am))^0.5;
Qmax=(2*pi)*((rc*rc)-(r*r))*h*(T[1]-T[2]);
Qactual=0.82*Qmax; //Value of fin efficiency taken with value of x in the figure 3.18 on Pg112

end Ex3_33;
//======================================================
