//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.5 Page 55
//Title: Rate of heat flow
//======================================================

model Ex3_5

//=============
// Parameter Section

parameter Real x(unit = "m") = 0.2 " Thickness of furnace wall";
parameter Real T[2] (unit = "C") = {1000,200} " Temperatures at the extremes";
parameter Real ko (unit = "W/m C") = 0.8130 " Thermal Conductivity at T=0";
parameter Real B (unit = "1/C") = 0.00071580 " Temperature coefficient of thermal conductivity";


//=============
// Variable Section
Real Q(unit= "W/m^2") " Heat Transfer Rate per unit area";
Real km(unit= "W/m C") " Thermal Conductivty at a mean temperature";


//=============
// Equation Section

equation

km=(ko)*(1+ B*((T[1]+T[2])/2));

Q=km*(T[1]-T[2])/x;

end Ex3_5;
//======================================================
