//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.10 Page 178
//Title: Temperature  
//======================================================

model Ex5_10
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Qo(unit="W/m^2")=0.3e6 " Constant heat flux";
parameter Real x(unit="m")=20e-2 " Thickness";
parameter Real k(unit="W/mK")=386 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=0.404 " Thermal Diffusivity";
parameter Real Ti(unit="C")=30 " Initial temperature";
parameter Real t(unit="min")=10 " Time";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Ts(unit="C")" Surface temperature";
Real T(unit="C")" Final temperature";

//=============
// Equation Section

equation

Qo=k*(Ts-Ti)/((pi*a1*t/60)^0.5);
(Ts-T)/(Ts-Ti)=Special.erf(x/(2*(a1*t/60)^0.5));

end Ex5_10;
//======================================================
