//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.18 Page 202
//Title: Surface Temperature
//======================================================

model Ex5_18
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x1(unit="m")=0.075 " Nodal spacing";
parameter Real x2(unit="m")=0.15 " Depth";
parameter Real k(unit="W/mK")=400 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=117e-6 " Thermal diffusivity";
parameter Real t(unit="minute")=4 " Time";//Obtained from table on Pg203

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real dt(unit="s") " Value of dt";
Real R(unit="") " Value of R";
Real To(unit="C") " Temperatures";//Obtained from table on Pg203
Real T2(unit="C") " Temperatures";//Obtained from table on Pg203

//=============
// Equation Section

equation

dt=x1*x1/(R*a1);
R=2;
To=121.9;
T2=64;


end Ex5_18;
//======================================================
