//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.21 Page 213
//Title: Amplitude of temperature and time lag
//======================================================

model Ex5_21
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=0.1 " Depth";
parameter Real t(unit="hour")=24 " Time period";
parameter Real k(unit="W/mK")=0.349 " Thermal Conductivity";
parameter Real p1(unit="W/mK")=1000 " Density";
parameter Real Cp(unit="J/kgK")=1970 " Specific heat";
parameter Real T[2](unit="C")={-10,10} " Maximum and minimum temperatures";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real a1(unit="m^2/hour") " Thermal Diffusivity";
Real Tomax(unit="C") " Temperature";
Real Txmax(unit="C") " Amplitude of temperature variation";
Real w(unit="rad/hour") " Angular frequency";
Real dt(unit="hour") " Time lag";
Real Tx(unit="C") " Temperature after reaching minimum surface temperature";

//=============
// Equation Section

equation

a1=k*3600/(p1*Cp);
w=2*pi/t;
Tomax=T[2]-((T[1]+T[2])/2);
Txmax=Tomax*(e^(-x*(w/(2*a1))^0.5));
dt=x*(1/(2*a1*w))^0.5;
Tx=(Tomax*(e^(-x*(w/(2*a1))^0.5)))*cos((57.296)*((w*17)-(x*(w/(2*a1))^0.5)));

//Error in value of Tx as cos(4.307) taken instead of cos(3.02) as obtained. This is due to error in w/2a calculation 

end Ex5_21;
//======================================================
