//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.24 Page 218
//Title: Time to cool highway 
//======================================================

model Ex5_24
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=5e-2 " Thickness";
parameter Real k(unit="W/mK")=1.279 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=1.77e-3 " Thermal Diffusivity";
parameter Real To(unit="C")=55 " Initial temperature";
parameter Real T(unit="C")=45 " Final temperature";
parameter Real Ts(unit="C")=35 " Surface temperature";
parameter Real t(unit="hour")=1.4 " Time to cool";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="W/m^2") " Instantaneous heat removal";

//=============
// Equation Section

equation

Q=k*(Ts-To)/(3*a1*t)^0.5;

end Ex5_24;
//======================================================
