//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.6 Page 167
//Title: Time constant
//======================================================

model Ex5_6
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real d(unit="m")=0.71e-3 " Diameter";
parameter Real h(unit="W/m^2 K")=600 " Convective Heat transfer coefficient";
parameter Real c(unit="J/kg K")=420 " Specific heat";
parameter Real p1(unit="kg/m^3")=8600 " Density";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real t1(unit="s") " Time constant";
Real t(unit="s") " Time period of acceptable reading" ;

//=============
// Equation Section

equation

t1=p1*c*d/(4*h);
t=integer(4*t1);

/*For getting a true reading of gas temperature, temperature should be recorded after 4t*= 4s after gas introduced in thermocouple*/

end Ex5_6;
//======================================================
