//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-6: Fundamentals of Convective Heat Transfer
//Example: 6.7 Page 257
//Title: Flow Type and Entry Length
//======================================================

model Ex6_7
extends Modelica.Math;
//=============
// Parameter Section

parameter Real id (unit = " m ") = 2e-2 " Internal Diameter of the tube ";
parameter Real v( unit = "m^2/s ")= 1e-6 " Kinematic viscosity of water ";
parameter Real Q( unit = "m^3/min ")= 1.5e-3 " Volumetric flow rate of water ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real u ( unit = "m/s") " Average velocity of water ";
Real Re(unit = "") " Reynolds Number ";
Real x (unit = " m ") " Entry length ";

//=============
// Equation Section

equation

u=(Q/60)/(pi*(id*id)/4);
Re=u*id/v;
x=0.05*id*Re; //Since flow was found to be laminar the expression is used.

end Ex6_7;
//======================================================
