//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-6: Fundamentals of Convective Heat Transfer
//Example: 6.8 Page 257
//Title: Head Loss and Power required 
//======================================================

model Ex6_8
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = " m ") = 3000 " Distance of transport ";
parameter Real id (unit = " m ") = 2e-2 " Internal Diameter of the tube ";
parameter Real v( unit = "m^2/s ")= 1e-6 " Kinematic viscosity of water ";
parameter Real Q( unit = "m^3/min ")= 1.5e-3 " Volumetric flow rate of water ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real u ( unit = "m/s") " Average velocity of water ";
Real Re(unit = "") " Reynolds Number ";
Real hL(unit = " m ") " Head Loss ";
Real P(unit = " W ") " Power required to maintain the flow ";

//=============
// Equation Section

equation

u=(Q/60)/(pi*(id*id)/4);
Re=u*id/v;
hL=((64/Re)*L*u*u)/(2*9.81*id);
P=1000*9.81*hL*(Q/60);

end Ex6_8;
//======================================================
