//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.10 Page 297
//Title: Heat transfer coefficient and admissible current intensity
//======================================================

model Ex7_10
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=1 " Velocity";
parameter Real T1(unit="C")=80 " Temperature of bar";
parameter Real T2(unit="C")=20 " Air Temperature";
parameter Real d(unit="m")=15e-3 " Bar diameter";
parameter Real P1(unit="ohm mm^2/m")=0.0175 " Resistivity of Copper ";

//Properties of air at film temperature 50C
parameter Real v1(unit = "m^2/s") = 1.89e-5 " Kinematic viscosity";
parameter Real Pr(unit="")=0.703 " Prandtl number";
parameter Real k(unit="W/m K")=28.15e-3 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient";
Real Nu(unit= "")" Nusselt no";
Real I(unit= "A")" Current maximum";

//=============
// Equation Section

equation

Re=u*(d/v1);
Nu=h*d/k;
Nu=0.3+(((0.62*(Re^0.5)*Pr^(1/3))/(1+(0.4/Pr)^(2/3))^(1/4))*(1+(Re/28200)^(5/8))^(4/5));
1000*(h*(pi*d)*(T1-T2))^0.5=I*((4*P1/(pi*d*d)))^0.5;

end Ex7_10;
//======================================================
