//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.15 Page 310
//Title: Average temperature of fluid
//======================================================

model Ex7_15
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real D(unit="m")=20e-2 " Outer Diameter";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real r(unit="m")" Radius";
Real u(unit="m/s")" Velocity";
Real T(unit= "C")" Temperature";

//=============
// Equation Section

equation

r=D/2;
u=64*r-(95*r*r);
T=(2/(u*(r^2))*(((9600*r^3)/3) -((38200*r^4)/4)+((38000*r^5)/5)));

end Ex7_15;
//======================================================
