//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.18 Page 312
//Title: Heat transfer coefficient and length of the tube
//======================================================

model Ex7_18
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Tw[2](unit="C")={25,50} " Water inlet and outer temperatures";
parameter Real D(unit="m")=50e-3 " Diameter";
parameter Real Re(unit="")=1600 " Reynolds no";
parameter Real q(unit="W/m")=800 " Constant heat flux";
parameter Real Nu(unit="")=4.364 "Nusselt no";

//Property values of water at 25C
parameter Real v1(unit="Pa s")=915e-6 " Viscosity";
parameter Real k(unit="W/mK")=610e-3 " Thermal conductivity";
parameter Real Cp(unit="J/kgK")=4178 " Specific heat of water at 37.5C";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real m(unit="kg/s")" Mass flow rate";
Real L(unit="m") " Length of tube";
Real h(unit= "W/m^2 K")" Heat transfer coefficient ";
Real qs(unit="W/m^2") " Heat Flux at surface";

//=============
// Equation Section

equation

Re=4*m/(pi*D*v1);
Nu=h*D/k;
qs=q/(pi*D*1);
q*L=m*Cp*(Tw[2]-Tw[1]);

end Ex7_18;
//======================================================
