//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.20 Page 318
//Title: Heat transfer coefficient using Colburn analogy
//======================================================

model Ex7_20
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=1 " Velocity ";
parameter Real Ts(unit="C")=30 " Temperature of surface";
parameter Real Tw(unit="C")=50 " Water temperature";
parameter Real D(unit="m")=5e-3 " Diameter";
parameter Real L(unit="m")=50e-2 " Length";

//Property values of water at 50C
parameter Real Cp(unit="J/kgK")=4178 " Specific heat";
parameter Real v2(unit="m^2/s")=5.67e-7 " Kinematic Viscosity";

//Property values of water at 40C
parameter Real v1(unit="m^2/s")=6.57e-7 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=628e-3 " Thermal conductivity";
parameter Real Pr(unit="W/mK")=4.34 " Prandtl No";
parameter Real p1(unit="kg/m^3")=995 " Density";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real h(unit="W/m^2 K")" Heat transfer coefficient ";
Real Re(unit="")" Reynolds No";

//=============
// Equation Section

equation

Re=u*D/v2;
(h/(p1*Cp*u))*Pr^(2/3)=(0.316/8)*(u*D/v1)^(-0.25);

//Error in h value. This is because D is taken as 0.5 instead of 0.05. Value of h is 6607W/m^2 K.

end Ex7_20;
//======================================================
