//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.22 Page 320
//Title: Average heat transfer coefficient using Sieder-Tate correlation
//======================================================

model Ex7_22
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=2 " Velocity";
parameter Real Ts(unit="C")=95 " Temperature of surface";
parameter Real Tw[2](unit="C")={15,60} " Water temperatures at inlet and outlet";
parameter Real D(unit="m")=2.2e-2 " Diameter";

//Property values of oil at 37.5C
parameter Real v1(unit="Pa s")=0.69e-3 " Viscosity";
parameter Real k(unit="W/mK")=0.63 " Thermal conductivity";
parameter Real Pr(unit="")=4.56 " Prandtl No";
parameter Real p1(unit="kg/m^3")=990 " Density";
parameter Real Cp(unit="J/kgK")=4160 " Specific heat";
parameter Real v2(unit="Pa s")=0.3e-3 " Viscosity at 95C";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nu(unit="")" Nusselt no from Sieder-Tate correlation";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")"Reynolds No";

//=============
// Equation Section

equation

Re=p1*D*u/v1;
Nu=0.027 *(Re^0.8)*(Pr^(1/3)) * (v1/v2)^(0.14);
Nu=h*D/k;

end Ex7_22;
//======================================================
