//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.16 Page 362
//Title: Heat transfer in tube
//======================================================

model Ex8_16
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real d (unit = " m ") = 20e-3 " Diameter of the tube ";
parameter Real T[2]( unit = " K ")= {300,400} " Temperatures of air and wall respectively";
parameter Real P( unit = " atm ")= 1 " Air pressure ";
parameter Real v( unit = " m/s ")= 30e-2 " Air velocity ";
parameter Real l (unit = " m ") =1 " Length of the tube ";

//Surface properties at 300 kelvin

parameter Real k (unit = " W/m K ") = 0.0262 " Thermal Conductivity of air ";
parameter Real v1 (unit = " kg/m s ") = 1.568e-5 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.708 " Prandtl Number ";
parameter Real u1[2]( unit = "Pa s") ={1.847e-5,2.286e-5} " Viscosity ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Re(unit ="") " Reynolds Number ";
Real Nu(unit ="") " Nusselt Number ";
Real Gr(unit ="") " Grashof Number ";
Real Gz(unit ="") " Graetz Number ";
Real h(unit =" W/m^2 K") " Heat transfer coefficient ";
Real Q(unit = " W") " Heat transfer in tube ";

//=============
// Equation Section

equation

B=1/T[1];
Re=v*d/v1;
Gr= (g_n*B*(d^3)*(T[2]-T[1]))/(v1^2);
Gz=Re*Pr*d/l;
Nu=1.75*(u1[1]/u1[2])^0.14*(Gz+0.012*(Gz*Gr^(1/3))^(4/3))^(1/3);
h=Nu*k/d;
Q=h*pi*d*l*(T[2]-T[1]);

end Ex8_16;
//======================================================
