//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.3 Page 343
//Title: Average Heat Transfer Coefficient and Rate of Heat Transfer
//======================================================

model Ex8_3
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.609 " Length of the metal plate ";
//Surface properties at 127 degree celsius
parameter Real k (unit = " W/m C ") = 33.8e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 26.4e-6 " Kinematic Viscosity of air ";
parameter Real a (unit = " m^2/s ") = 38.3e-6 " Thermal Diffusivity of air ";
parameter Real Pr (unit = "") = 0.69 " Prandtl Number ";
parameter Real T[2]( unit = " C ")= {161,93} " Temperatures of oven and air respectively ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tf( unit = "C") " Film Temperature ";
Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu[2]( unit = "") " Nusselt Number ";
Real h(unit = "W/m^2 C") " Average heat transfer coefficient ";
Real Q(unit = "W") " Rate of heat transfer ";

//=============
// Equation Section

equation


Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Ra= (g_n*B*(L^3))*(T[1]-T[2])/(v1*a);
Nu[1]=0.68 + (0.670*(Ra^0.25))/((1 + (0.492/Pr)^(9/16))^(4/9));  
h=Nu[1]*k/L;
Q=h*L*(T[1]-T[2]);
Nu[2]=0.59*(Ra)^0.25;


end Ex8_3;
//======================================================
