//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.7 Page 348
//Title: Heat transfer coefficient of an ingot
//======================================================

model Ex8_7
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L[3] (unit = " m ") = {0.05,0.08,0.12} " Dimensions of the ingot";
parameter Real T[2]( unit = " C ")= {0,50} " Temperatures of air and ingot respectively";

//Surface properties at 25 degree celsius
parameter Real B (unit = " K^-1 ")=3.33e-3" Volumetric Coefficient of air ";
parameter Real k (unit = " W/m C ") = 26.3e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 15.89e-6 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.707 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section


Real Tf(unit = "C") " Film Temperature ";
Real Lc(unit = "m") " Characterisitic Length ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real h(unit = "W/m^2 C") " Average heat transfer coefficient";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
Lc=(L[2]*L[3])/(L[2]+L[3]);
Ra= ((g_n*B*(Lc^3)*(T[2]-T[1])*Pr))/(v1^2);
Nu=0.55*(Ra^0.25);
h=Nu*k/Lc;

//Error in Rayleigh no as Prandtl no has been missed in calculations. The required answer is 8.0359W/m^2K

end Ex8_7;
//======================================================
