//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.2 Page 383
//Title: Fraction of thermal radiation
//======================================================

model Ex9_2
extends Modelica.Math;
//=============
// Parameter Section

parameter Real l[2] (unit = " micro m ") = {1,5} " Wavelengths ";
parameter Real T( unit = " C ")= 727 " Temperature of the black body ";
parameter Real F[2]( unit = "") = {0.6337,0.0003} "Fractional Emissive Power from Table 9.2 on page 385";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real Q(unit = " kW/m^2 ")" Heat transfer ";
Real Fr(unit = " kW/m^2 ")" Fractional of thermal radiation emitted";

//=============
// Equation Section

equation

Q=(sigma*(T+273)^4)/1000;
Fr=Q*(F[1]-F[2]);

end Ex9_2;
//======================================================
