//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.4 Page 386
//Title: Temperature and Emissive power of the sun
//======================================================

model Ex9_4
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.5e-6 " Wavelength of radiation ";
parameter Real C3 (unit = " mK") = 0.289e-2 " Wien's Displacement Law ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";

//=============
// Variable Section

Real T( unit = " K ") " Temperature of the sun ";
Real Eb( unit = "MW/m^2 ")" Emissive power of sun ";

//=============
// Equation Section

equation

T=C3/L;
Eb=sigma*(T^4)/(1e6);

end Ex9_4;
//======================================================
