//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-1: Basic Concepts
//Example: 1.2 Page 11
//Title: Basic Convective Heat Transfer
//======================================================

model Ex1_2
//=============
// Parameter Section

parameter Real l(unit = "m") = 1 " Length of the plate ";
parameter Real w(unit = "m") = 0.5 " Width of the plate ";
parameter Real T[2](unit = "C") = {300,30} " Respective Temperatures ";
parameter Real h(unit = "W/m^2 C") = 30 " Convective heat transfer coefficient ";

//=============
// Variable Section

Real A(unit="m^2") "Area of the plate ";
Real Q(unit= "kW") " Heat Transfer Rate ";

//=============
// Equation Section

equation

A=l*w;
Q= (A*h*(T[1]-T[2]))/1000;

end Ex1_2;
//======================================================
