//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.14 Page 424
//Title: Net heat exchange and equilibrium temperature
//======================================================

model Ex10_14
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=313 " Temperature of floor";
parameter Real T2(unit="K")=278 " Temperature of window";
parameter Real A(unit="m^2")=120 " Total Area";
parameter Real A1(unit="m^2")=20 " Area";
parameter Real A2(unit="m^2")=12 " Area";
parameter Real F56(unit="")=0.075 " Shape factor";
parameter Real F63(unit="")=0.04 " Shape factor";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real F12(unit="")" Shape factor";
Real F12b(unit="")" Shape factor";
Real Q12(unit="W")" Heat transferred between floor and window";
Real Tr(unit="K")" Equilibrium temperature of reradiating walls";

//=============
// Equation Section

equation

F12=(1/A)*((8*12*F56)-(2*12*F63));
F12b=(A2-(A1*F12*F12))/(A1+A2-2*(A1*F12));
Q12=sigma*A*F12b*((T1^4)-(T2^4));
((T1^4)-(Tr^4))/((Tr^4)-(T2^4))=((A2/A1)-F12)/(1-F12);

//Error in Tr value. This is because A2/A1-F12 is taken as 0.048 instead of 0.548. Thus Tr is 301K

end Ex10_14;
//======================================================
