//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.24 Page 448
//Title: Number of screens
//======================================================

model Ex10_24
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real Q(unit="")=79 " Reduction in heat exchange";
parameter Real e1(unit="")=0.8 " Emissivity of surfaces";
parameter Real e2(unit="")=0.05 " Emissivity of screens";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real n(unit="")" Number of screens";

//=============
// Equation Section

equation

Q=( (2/e1) + (2*n/e2)-n-1)/((2/e1)-1);

end Ex10_24;
//======================================================
