//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.28 Page 453
//Title: Heat transfer coefficients
//======================================================

model Ex10_28
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T1(unit="K")=473 " Temperature of first plate";
parameter Real T2(unit="K")=303 " Temperature of second plate";
parameter Real e(unit="")=0.8 " Emissivity";
parameter Real h(unit="W/m^2 K")=17.98 " Overall heat transfer coefficient";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="W/m^2")" Heat exchange per unit area";
Real hc(unit="W/m^2 K")" Heat transfer coefficient by convection";
Real hr(unit="W/m^2 K")" Heat transfer coefficient by radiation";

//=============
// Equation Section

equation

Q=sigma*e*((T1^4)-(T2^4));
hr=Q/(T1-T2);
hc=h-hr;

end Ex10_28;
//======================================================
