//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.30 Page 462
//Title: Emissivity of gas mixture
//======================================================

model Ex10_30
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real T(unit="K")=1273 " Temperature ";
parameter Real V(unit="m^3")=10 " Volume ";
parameter Real A(unit="m^2")=30 " Surface Area ";
parameter Real Pt(unit="atm")=2 " Total pressure ";
parameter Real pCO2(unit="atm")=0.3 " Partial pressure of CO2";
parameter Real pH2O(unit="atm")=0.1 " Partial pressure of H2O";
parameter Real eCO2(unit="")=0.16 " Emissivity of CO2";//From Fig10.23 on pg 458
parameter Real eH2O(unit="")=0.12 " Emissivity of H2O";//From Fig10.24 on pg 459
parameter Real cCO2(unit="")=1.11 " Correction factor of CO2";//From Fig10.25 on pg 460
parameter Real cH2O(unit="")=1.43 " Correction factor of H2O";//From Fig10.26 on pg 460
parameter Real E(unit="")=0.035 " Error factor";//From Fig10.27 on pg 461

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Lms(unit="m") " Mean beam length";
Real pLmsCO2(unit="atm m") " Value of pLms";
Real pLmsH2O(unit="atm m") " Value of pLms";
Real pLms(unit="atm m") " Value of pLms summed";
Real et(unit="")" Total emissivity";

//=============
// Equation Section

equation

Lms=3.6*V/A;
pLmsCO2=pCO2*Lms;
pLmsH2O=pH2O*Lms;
pLms=pLmsH2O+pLmsCO2;
et=(eCO2*cCO2)+(eH2O*cH2O)-E;

end Ex10_30;
//======================================================
