//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-10: Radiative Heat Exchange Between Surfaces
//Example: 10.5 Page 411
//Title: Shape factor
//======================================================

model Ex10_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real A51(unit="m^2")=2 " Area";
parameter Real A21(unit="m^2")=1 " Area";
parameter Real F56(unit="")=0.15 " Shape factor";
parameter Real F53(unit="")=0.11 " Shape factor";
parameter Real F26(unit="")=0.24 " Shape factor";
parameter Real F23(unit="")=0.2 " Shape factor";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real F14(unit="")" Shape Factor 1,4";

//=============
// Equation Section

equation

F14=A51*(F56-F53)- A21*(F26-F23);

end Ex10_5;
//======================================================
