//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.10 Page 494
//Title: Change in condensation rate
//======================================================

model Ex11_10
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L(unit = " m ") = 1 " Length of tube "; 
parameter Real D(unit = " m ") = 1e-2 " Diameter of tube ";
parameter Real N(unit = "") = 10 " Number of tube in one array ";
parameter Real mh(unit= "kg/hr")=50 " Mass flow rate of condensate in horizontal position";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real mv(unit= "W/m^2 K") " Local Heat transfer coefficient ";

//=============
// Equation Section

equation

(mh/mv)=(0.725/1.13)*((L/( N*D) )^0.25);

end Ex11_10;
//======================================================
