//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-11: Boiling and Condensation
//Example: 11.5 Page 485
//Title: Heat Transfer in boiling tube
//======================================================

model Ex11_5
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real P(unit = " atm") =6 " Pressure given ";
parameter Real D(unit = " m ") = 2e-2 " Diameter of tube "; 
parameter Real L(unit = " m ") = 1 " Length of tube "; 
parameter Real T(unit = "C") =10 " Temperature difference ";
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real h(unit= "W/m^2 K") " Heat transfer coefficient ";
Real Q(unit= "W/m") " Heat Dissipation rate per unit length ";

//=============
// Equation Section

equation

h=2.54*(T^3)*e^((P*1.01325e-1)/1.551);
Q=h*pi*D*T*L;

end Ex11_5;
//======================================================
